/*
 * Decompiled with CFR 0.152.
 */
package icyllis.modernui.platform;

import icyllis.modernui.platform.VideoMode;
import it.unimi.dsi.fastutil.longs.Long2ObjectArrayMap;
import it.unimi.dsi.fastutil.longs.Long2ObjectMap;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.lwjgl.PointerBuffer;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.system.MemoryStack;

public final class Monitor {
    private static final Long2ObjectMap<Monitor> sMonitors = new Long2ObjectArrayMap();
    private final long mNativePtr;
    private final int mXPos;
    private final int mYPos;
    private final VideoMode[] mVideoModes;

    private static void callbackMonitor(long monitor, int event) {
        if (event == 262145) {
            sMonitors.put(monitor, (Object)new Monitor(monitor));
        } else if (event == 262146) {
            sMonitors.remove(monitor);
        }
    }

    @Nullable
    public static Monitor get(long ptr) {
        return (Monitor)sMonitors.get(ptr);
    }

    @Nullable
    public static Monitor getPrimary() {
        return (Monitor)sMonitors.get(GLFW.glfwGetPrimaryMonitor());
    }

    @Nonnull
    public static Collection<Monitor> getAll() {
        return sMonitors.values();
    }

    private Monitor(long ptr) {
        this.mNativePtr = ptr;
        try (MemoryStack stack = MemoryStack.stackPush();){
            IntBuffer x = stack.mallocInt(1);
            IntBuffer y = stack.mallocInt(1);
            GLFW.glfwGetMonitorPos((long)ptr, (IntBuffer)x, (IntBuffer)y);
            this.mXPos = x.get(0);
            this.mYPos = y.get(0);
        }
        ArrayList<VideoMode> list = new ArrayList<VideoMode>();
        GLFWVidMode.Buffer buffer = GLFW.glfwGetVideoModes((long)ptr);
        if (buffer == null) {
            throw new IllegalStateException("Failed to get video modes");
        }
        for (int i = buffer.limit() - 1; i >= 0; --i) {
            buffer.position(i);
            VideoMode m3 = new VideoMode(buffer);
            if (m3.getRedBits() < 8 || m3.getGreenBits() < 8 || m3.getBlueBits() < 8) continue;
            list.add(m3);
        }
        this.mVideoModes = list.toArray(new VideoMode[0]);
    }

    public long getNativePtr() {
        return this.mNativePtr;
    }

    public int getXPos() {
        return this.mXPos;
    }

    public int getYPos() {
        return this.mYPos;
    }

    @Nonnull
    public VideoMode getCurrentMode() {
        GLFWVidMode mode = GLFW.glfwGetVideoMode((long)this.mNativePtr);
        if (mode == null) {
            throw new IllegalStateException("Failed to get current video mode");
        }
        return new VideoMode(mode);
    }

    @Nullable
    public String getName() {
        return GLFW.glfwGetMonitorName((long)this.mNativePtr);
    }

    public int getModeCount() {
        return this.mVideoModes.length;
    }

    @Nonnull
    public VideoMode getModeAt(int index) {
        return this.mVideoModes[index];
    }

    @Nonnull
    public VideoMode findBestMode(int width, int height) {
        return Arrays.stream(this.mVideoModes).filter(m3 -> m3.getWidth() <= width && m3.getHeight() <= height).sorted((c1, c2) -> c2.getWidth() - c1.getWidth()).sorted((c1, c2) -> c2.getHeight() - c1.getHeight()).max(Comparator.comparingInt(VideoMode::getRefreshRate)).orElse(this.mVideoModes[0]);
    }

    static {
        GLFW.glfwSetMonitorCallback(Monitor::callbackMonitor);
        PointerBuffer pointers = GLFW.glfwGetMonitors();
        if (pointers != null) {
            for (int i = 0; i < pointers.limit(); ++i) {
                long ptr = pointers.get(i);
                sMonitors.put(ptr, (Object)new Monitor(ptr));
            }
        }
    }
}

